﻿#using Tessa.Extensions.Platform.Server.Cards;

var storeContext = (ICardStoreExtensionContext)this.CardContext;

// Получение файлового сателлита.
var fsCard = await FileSatelliteHelper.GetFileSatelliteAsync(
	storeContext,
	this.Resolve<ICardRepository>(CardRepositoryNames.ExtendedWithoutTransaction),
	true);

// При получении файлового сателлита произошла ошибка. Информация об ошибке записана в ICardStoreExtensionContext.ValidationResult.
if(fsCard is null)
{
	return;
}

var files = fsCard.TryGetFiles();

foreach(var file in files)
{
	file.State = CardFileState.Deleted;
}

// Сохранение карточки файлового сателлита.
await FileSatelliteHelper.StoreFileSatelliteAsync(
	storeContext,
	this.Resolve<ICardStreamServerRepository>(CardRepositoryNames.ExtendedWithoutTransaction));